(function(){
  const SAJiL=window.SAJIL=window.SAJIL||{}; SAJiL.features=SAJiL.features||{};
  const F=SAJiL.features.settings={};
  const $=(id)=>document.getElementById(id);

  function apply(){
    const s=SAJiL.state.settings;
    $('setEnableUSD').checked=!!s.enableUSD;
    $('setGuessType').checked=!!s.guessType;
    $('setPrivacy').checked=!!s.privacy;
    $('setAutoTags').checked=!!s.autoTags;
    $('setSuggestCurrency').checked=!!s.suggestCurrency;
    $('setSuggestReports').checked=!!s.suggestReports;
    $('setRequireReason').checked=!!s.requireReason;
    $('setGoalsOn').checked=!!s.goalsOn;
    $('goalCard').classList.toggle('show', !!s.goalsOn);
	$('setAnimations') && ($('setAnimations').checked = (s.animations !== false));
$('setReduceMotion') && ($('setReduceMotion').checked = !!s.reduceMotion);
    $('goalExpense').value=s.goalExpense?String(s.goalExpense):'';
    // Lock settings
    if(document.getElementById('setEnableLock')){
      document.getElementById('setEnableLock').checked = !!s.enableLock;
      const lc = document.getElementById('lockCard');
      if(lc) lc.style.display = s.enableLock ? 'block' : 'none';
    }
	
	if(document.getElementById('setAutoNetColor')){
  document.getElementById('setAutoNetColor').checked = (s.autoNetColor !== false);
}
if(document.getElementById('setTheme')){
  document.getElementById('setTheme').value = s.theme || 'auto';
}


    $('goalNet').value=s.goalNet?String(s.goalNet):'';
  }

  function patch(p){
    Object.assign(SAJiL.state.settings,p);
    SAJiL.storage.setSettings(SAJiL.state.settings);
    apply();
    SAJiL.render();
  }

  F.init=function(){
    apply();

    // ✅ FIX: enableUSD should NOT be default ON (handled in core.js defaults)
    // ✅ FIX: when enableUSD toggled OFF -> force currency ₪
    $('setEnableUSD').addEventListener('change', ()=>{
      const on = $('setEnableUSD').checked;
      patch({enableUSD:on});
      if(!on){
        SAJiL.state.currency = '₪';
        // also normalize lastCurrency so AI suggestion doesn't keep popping
        SAJiL.state.settings.lastCurrency = '₪';
        SAJiL.storage.setSettings(SAJiL.state.settings);
      }
      SAJiL.render();
    });

    $('setGuessType').addEventListener('change',()=>patch({guessType:$('setGuessType').checked}));
    $('setPrivacy').addEventListener('change',()=>patch({privacy:$('setPrivacy').checked}));
    $('setAutoTags').addEventListener('change',()=>patch({autoTags:$('setAutoTags').checked}));
    $('setSuggestCurrency').addEventListener('change',()=>patch({suggestCurrency:$('setSuggestCurrency').checked}));
    $('setSuggestReports').addEventListener('change',()=>patch({suggestReports:$('setSuggestReports').checked}));
    $('setRequireReason').addEventListener('change',()=>patch({requireReason:$('setRequireReason').checked}));
    $('setGoalsOn').addEventListener('change',()=>patch({goalsOn:$('setGoalsOn').checked}));

    $('saveGoals').addEventListener('click',()=>{
      const ge=parseFloat(($('goalExpense').value||'').replace(/[^\d.]/g,''))||0;
      const gn=parseFloat(($('goalNet').value||'').replace(/[^\d.]/g,''))||0;
      patch({goalExpense:ge,goalNet:gn}); SAJiL.util.haptic(10);
    });

    // Lock listeners
    if(document.getElementById('setEnableLock')){
      document.getElementById('setEnableLock').addEventListener('change', ()=>{
        const on = document.getElementById('setEnableLock').checked;
        patch({enableLock:on});
        const lc = document.getElementById('lockCard');
        if(lc) lc.style.display = on ? 'block' : 'none';
      });
    }
    if(document.getElementById('savePinBtn')){
      document.getElementById('savePinBtn').addEventListener('click', ()=>{
        const v = (document.getElementById('setPinInput').value||'').replace(/\D/g,'');
        if(v.length < 4){ SAJiL.toast ? SAJiL.toast('اكتب PIN من 4 أرقام') : alert('اكتب PIN من 4 أرقام'); return; }
        patch({pin:v});
        SAJiL.toast ? SAJiL.toast('تم حفظ PIN') : alert('تم حفظ PIN');
        SAJiL.util.haptic(10);
      });
    }
	document.getElementById('setAutoNetColor')?.addEventListener('change', ()=>{
  patch({ autoNetColor: document.getElementById('setAutoNetColor').checked });
  SAJiL.render();
});

document.getElementById('setTheme')?.addEventListener('change', ()=>{
  patch({ theme: document.getElementById('setTheme').value });
  SAJiL.applyTheme && SAJiL.applyTheme();
});

document.getElementById('setAnimations')?.addEventListener('change', ()=>{
  patch({ animations: document.getElementById('setAnimations').checked });
  SAJiL.applyMotion && SAJiL.applyMotion();
});

document.getElementById('setReduceMotion')?.addEventListener('change', ()=>{
  patch({ reduceMotion: document.getElementById('setReduceMotion').checked });
  SAJiL.applyMotion && SAJiL.applyMotion();
});

    $('btnReset').addEventListener('click',()=>{
      if(!confirm('سيتم مسح كل البيانات. هل أنت متأكد؟')) return;
      localStorage.clear();
      SAJiL.state.settings = SAJiL.storage.getSettings();
      SAJiL.state.currency = '₪';
      apply(); SAJiL.render();
    });
  };
})();
