(function(){
  const SAJiL=window.SAJIL=window.SAJIL||{}; SAJiL.features=SAJiL.features||{};
  const F=SAJiL.features.naturalSearch={};
  function parse(q){
    const out={period:null,type:null,note:null,min:null,max:null,range:null};
    const s=(q||'').trim(); if(!s) return out;
    const low=s.toLowerCase();
    if(/\bمصروف\b/.test(low) || low.startsWith('-')) out.type='expense';
    if(/\bمدخول\b/.test(low) || low.startsWith('+')) out.type='income';
    if(low.includes('اليوم')) out.period='today';
    if(low.includes('أمس')||low.includes('امس')) out.period='yesterday';
    if(low.includes('قبل أمس')||low.includes('قبل امس')) out.period='before_yesterday';
    if(low.includes('هذا الأسبوع')||low.includes('هذا الاسبوع')||low.includes('أسبوع')||low.includes('اسبوع')) out.period = out.period || 'week';
    if(low.includes('هذا الشهر')||low.includes('شهر')) out.period = out.period || 'month';
    const min=low.match(/(فوق|أكثر من|اكثر من|≥)\s*(\d+(?:\.\d+)?)/); if(min) out.min=parseFloat(min[2]);
    const max=low.match(/(أقل من|اقل من|≤)\s*(\d+(?:\.\d+)?)/); if(max) out.max=parseFloat(max[2]);
    const between=low.match(/بين\s*(\d{4}-\d{2}-\d{2})\s*(و|إلى|الى)\s*(\d{4}-\d{2}-\d{2})/);
    if(between){ out.range={from:new Date(between[1]+'T00:00:00'), to:new Date(between[3]+'T23:59:59')}; out.period='custom'; }
    let note=s;
    ['اليوم','أمس','امس','قبل أمس','قبل امس','هذا الأسبوع','هذا الاسبوع','أسبوع','اسبوع','هذا الشهر','شهر','مصروف','مدخول','فوق','أكثر من','اكثر من','أقل من','اقل من','بين','و','إلى','الى','≥','≤','+','-'].forEach(t=>{ note=note.split(t).join(' '); });
    note=note.replace(/\d{4}-\d{2}-\d{2}/g,' ').replace(/\d+(?:\.\d+)?/g,' ').replace(/[$₪]/g,' ').replace(/\s+/g,' ').trim();
    if(note) out.note=note;
    return out;
  }
  F.applyFilter=function(items,q){
    if(!q) return items;
    const p=parse(q);
    if(p.type) items=items.filter(t=>t.type===p.type);
    if(p.note){ const n=p.note.toLowerCase(); items=items.filter(t=>(t.note||'').toLowerCase().includes(n)||(t.tags||[]).join(' ').toLowerCase().includes(n)); }
    if(p.min!=null) items=items.filter(t=>(t.amount||0)>=p.min);
    if(p.max!=null) items=items.filter(t=>(t.amount||0)<=p.max);
    return items;
  };
  F.renderHint=function(q){
    if(!q){ SAJiL.ui.searchHint().textContent='تلميح: “أمس تلفونات” • “هذا الأسبوع مصروف” • “بين 2026-01-01 و 2026-01-10” • “فوق 500”'; return; }
    const p=parse(q), parts=[];
    if(p.period) parts.push('فترة: '+SAJiL.periodLabel(p.period));
    if(p.type) parts.push('نوع: '+(p.type==='income'?'مدخول':'مصروف'));
    if(p.note) parts.push('ملاحظة: '+p.note);
    if(p.min!=null) parts.push('≥ '+p.min);
    if(p.max!=null) parts.push('≤ '+p.max);
    if(p.range) parts.push('مدى: '+p.range.from.toISOString().slice(0,10)+' → '+p.range.to.toISOString().slice(0,10));
    SAJiL.ui.searchHint().textContent = parts.length ? ('يفهم البحث: '+parts.join(' • ')) : 'بحث نصّي.';
  };
})();