(function(){
  const SAJiL = window.SAJIL = window.SAJIL || {};
  SAJiL.features = SAJiL.features || {};
  const F = SAJiL.features.insightsCards = {};

  const $ = (id)=>document.getElementById(id);

  function sumRange(fromMs,toMs){
    const all=SAJiL.storage.getTx();
    let inc=0,exp=0;
    all.forEach(t=>{
      if(!t || !t.date) return;
      if(t.currency!=='₪') return;
      const ms=new Date(t.date).getTime();
      if(ms<fromMs||ms>toMs) return;
      if(t.type==='income') inc+=(+t.amount||0); else exp+=(+t.amount||0);
    });
    return {inc:Math.round(inc), exp:Math.round(exp), net:Math.round(inc-exp)};
  }

  function weekWindow(offsetDays){
    const now=new Date();
    const end=new Date(now); end.setDate(end.getDate()-offsetDays);
    const to = new Date(end.getFullYear(), end.getMonth(), end.getDate(), 23,59,59,999).getTime();
    const from = to - 6*24*3600*1000;
    return {from,to};
  }

  function topExpenseDay(fromMs,toMs){
    const all=SAJiL.storage.getTx();
    const m={};
    all.forEach(t=>{
      if(!t||!t.date) return;
      if(t.currency!=='₪') return;
      const ms=new Date(t.date).getTime();
      if(ms<fromMs||ms>toMs) return;
      const k=t.date.slice(0,10);
      if(!m[k]) m[k]=0;
      if(t.type==='expense') m[k]+=(+t.amount||0);
    });
    const arr=Object.entries(m).sort((a,b)=>b[1]-a[1]);
    if(!arr.length) return null;
    return {key:arr[0][0], exp:Math.round(arr[0][1])};
  }

  function render(){
    const card = $('insightsCard');
    const list = $('insightsList');
    if(!card || !list) return;

    // This week vs last week
    const w1=weekWindow(0);
    const w0=weekWindow(7);
    const a=sumRange(w1.from,w1.to);
    const b=sumRange(w0.from,w0.to);
    const deltaExp = a.exp - b.exp;
    const topDay = topExpenseDay(w1.from,w1.to);

    const lines=[];
    lines.push(`📊 هذا الأسبوع: ⬆︎ ${a.inc}₪ • ⬇︎ ${a.exp}₪ • صافي ${a.net}₪`);
    lines.push(`↔️ مقارنة بالأسبوع الماضي: ${deltaExp>=0?'⬆︎ +':'⬇︎ '}${Math.abs(deltaExp)}₪ مصروف`);
    if(topDay) lines.push(`🔥 أكثر يوم صرفًا هذا الأسبوع: ${topDay.key} (${topDay.exp}₪)`);
    if((SAJiL.state.settings?.goalsOn) && (+SAJiL.state.settings.goalExpense||0)>0){
      const pct = Math.round((a.exp/(+SAJiL.state.settings.goalExpense))*100);
      lines.push(`🎯 نسبة المصروف من الهدف: ${isFinite(pct)?pct:0}%`);
    }

    list.innerHTML = '';
    lines.forEach(t=>{
      const div=document.createElement('div');
      div.className='insightItem';
      div.textContent=t;
      list.appendChild(div);
    });

    card.classList.remove('hidden');
  }

  F.render = render;
  F.init = function(){};
})();
