(function(){
  const SAJiL=window.SAJIL=window.SAJIL||{}; SAJiL.features=SAJiL.features||{};
  const F=SAJiL.features.groups={};
  const $=(id)=>document.getElementById(id);

  function openSheet(){
    SAJiL.ui.modalBackdrop().classList.remove('hidden');
    $('groupsSheet').classList.remove('hidden');
  }

  function closeSheet(){
    $('groupsSheet').classList.add('hidden');
  }

  function render(mode){
    const all = SAJiL.storage.getTx();
    const map = {};

    all.forEach(t=>{
      const keys = [];
      if(mode==='note'){
        keys.push((t.note||'—').trim());
      }else{
        (t.tags||[]).forEach(tag=>keys.push(tag));
      }
      if(!keys.length) keys.push('بدون وسم');

      keys.forEach(k=>{
        map[k]=map[k]||{income:0,expense:0,items:[]};
        if(t.type==='income') map[k].income += t.amount;
        else map[k].expense += t.amount;
        map[k].items.push(t);
      });
    });

    const list = $('groupsList');
    const entries = Object.entries(map).sort((a,b)=> (b[1].income-b[1].expense) - (a[1].income-a[1].expense));
    list.innerHTML='';

    entries.forEach(([k,v])=>{
      const net = v.income - v.expense;
      const div=document.createElement('div');
      div.className='card';
      div.innerHTML = `
        <div style="display:flex;justify-content:space-between;gap:10px;align-items:center">
          <b>${SAJiL.util.esc(k)}</b>
          <b>${SAJiL.util.fmtMoney(net,'₪',SAJiL.state.settings.privacy)}</b>
        </div>
        <div class="muted">⬆︎ ${SAJiL.util.fmtMoney(v.income,'₪',SAJiL.state.settings.privacy)} • ⬇︎ ${SAJiL.util.fmtMoney(v.expense,'₪',SAJiL.state.settings.privacy)} • عدد ${v.items.length}</div>
        <button class="btn ghost" style="margin-top:10px;width:100%" data-key="${SAJiL.util.esc(k)}">عرض العمليات</button>
      `;
      div.querySelector('button').addEventListener('click', ()=>{
        // فلترة سريعة داخل البحث
        SAJiL.ui.searchInput().value = k;
        SAJiL.state.search = k;
        closeSheet();
        SAJiL.render();
      });
      list.appendChild(div);
    });
  }

  F.open=function(){
    $('grpModeNote').classList.add('active');
    $('grpModeTags').classList.remove('active');
    render('note');
    openSheet();
  };

  F.init=function(){
    $('closeGroups').addEventListener('click', closeSheet);
    $('grpModeNote').addEventListener('click', ()=>{
      $('grpModeNote').classList.add('active');
      $('grpModeTags').classList.remove('active');
      render('note');
    });
    $('grpModeTags').addEventListener('click', ()=>{
      $('grpModeTags').classList.add('active');
      $('grpModeNote').classList.remove('active');
      render('tags');
    });
  };
})();
