(function(){
  const SAJiL=window.SAJIL=window.SAJIL||{}; SAJiL.features=SAJiL.features||{};
  const F=SAJiL.features.editHistory={};
  const $=(id)=>document.getElementById(id);

  const LS_CH='sajil_changes_v1';

  function getAllChanges(){
    try{ return JSON.parse(localStorage.getItem(LS_CH)||'{}'); }catch{ return {}; }
  }
  function saveAllChanges(obj){
    localStorage.setItem(LS_CH, JSON.stringify(obj));
  }
  function addChange(txId, entry){
    const db=getAllChanges();
    db[txId]=db[txId]||[];
    db[txId].push(entry);
    saveAllChanges(db);
  }
  function listChanges(txId){
    const db=getAllChanges();
    return (db[txId]||[]).slice().sort((a,b)=>b.at-a.at);
  }

  function findTx(id){
    return SAJiL.storage.getTx().find(t=>t.id===id) || null;
  }
  function updateTx(updated){
    const all=SAJiL.storage.getTx();
    const i=all.findIndex(t=>t.id===updated.id);
    if(i>=0) all[i]=updated;
    SAJiL.storage.setTx(all);
  }

  function openSheet(){
    SAJiL.ui.modalBackdrop().classList.remove('hidden');
    $('editSheet').classList.remove('hidden');
  }
  function closeSheet(){
    $('editSheet').classList.add('hidden');
    // لا تغلق backdrop إذا فيه sheets ثانية
  }

  function renderHistory(id){
    const list=$('historyList');
    const items=listChanges(id);
    list.innerHTML = items.length ? '' : '<div class="muted">لا يوجد تعديلات بعد.</div>';
    items.forEach(h=>{
      const when=new Date(h.at).toLocaleString('ar',{hour12:false});
      const div=document.createElement('div');
      div.className='historyItem';
      div.innerHTML = `<b>${SAJiL.util.esc(h.title||'تعديل')}</b>
        <div class="muted">${SAJiL.util.esc(h.detail||'')}</div>
        <div class="muted">${when}${h.reason?(' • السبب: '+SAJiL.util.esc(h.reason)) : ''}</div>`;
      list.appendChild(div);
    });
  }

  let editingId=null;

  F.open=function(id){
    const tx=findTx(id);
    if(!tx) return;

    editingId=id;
    $('editType').value = tx.type;
    $('editAmount').value = String(tx.amount);
    $('editCurrency').value = tx.currency || '₪';
    $('editNote').value = tx.note || '';
    $('editTags').value = (tx.tags||[]).join('، ');
    $('editReason').value = '';

    const d=new Date(new Date(tx.date).getTime() - new Date().getTimezoneOffset()*60000);
    $('editDate').value = d.toISOString().slice(0,16);

    $('reasonRow').classList.toggle('hidden', !SAJiL.state.settings.requireReason);

    renderHistory(id);
    openSheet();
  };

  F.init=function(){
    // close
    $('closeEdit').addEventListener('click', ()=>{ $('editSheet').classList.add('hidden'); });

    // reason chips
    $('reasonChips').addEventListener('click',(e)=>{
      const c=e.target.closest('.chip'); if(!c) return;
      $('editReason').value = c.dataset.reason;
      SAJiL.util.haptic(5);
    });

    $('saveEdit').addEventListener('click', ()=>{
      if(!editingId) return;
      const old=findTx(editingId);
      if(!old) return;

      const type=$('editType').value;
      const amount=parseFloat(($('editAmount').value||'').replace(/[^\d.]/g,''))||0;
      const currency=$('editCurrency').value;
      const note=($('editNote').value||'').trim()||'—';
      const date=$('editDate').value ? new Date($('editDate').value).toISOString() : old.date;
      const tags=($('editTags').value||'').split(/[،,]/).map(x=>x.trim()).filter(Boolean);
      const reason=($('editReason').value||'').trim();

      if(!amount || amount<=0){ alert('أدخل مبلغ صحيح'); return; }
      if(SAJiL.state.settings.requireReason && !reason){ alert('سبب التعديل مطلوب'); return; }

      const updated=Object.assign({}, old, {type,amount,currency,note,date,tags,updatedAt:Date.now()});
      updateTx(updated);

      const diffs=[];
      if(old.type!==type) diffs.push(`النوع: ${old.type==='income'?'مدخول':'مصروف'} → ${type==='income'?'مدخول':'مصروف'}`);
      if(old.amount!==amount || old.currency!==currency) diffs.push(`المبلغ: ${old.amount}${old.currency} → ${amount}${currency}`);
      if(old.note!==note) diffs.push(`الملاحظة: “${old.note}” → “${note}”`);
      if(new Date(old.date).getTime() !== new Date(date).getTime()) diffs.push(`التاريخ: ${SAJiL.util.fmtDate(old.date)} → ${SAJiL.util.fmtDate(date)}`);
      if((old.tags||[]).join('|') !== (tags||[]).join('|')) diffs.push(`الوسوم: ${(old.tags||[]).join(' ')} → ${(tags||[]).join(' ')}`);

      if(diffs.length){
        addChange(editingId, {at:Date.now(), reason: reason||null, title:'تم تعديل العملية', detail: diffs.join(' • ')});
      }

      renderHistory(editingId);
      SAJiL.util.haptic(10);
      SAJiL.render();
    });
  };
})();
