(function(){
  const SAJiL = window.SAJIL = window.SAJIL || {};
  const $ = (id)=>document.getElementById(id);

  SAJiL.state = { period:'today', customFrom:null, customTo:null, type:'income', search:'', ai:null, undo:null, settings:null };

  SAJiL.ui = {
    periodLabel:()=>$('periodLabel'), sumIncome:()=>$('sumIncome'), sumExpense:()=>$('sumExpense'), sumNet:()=>$('sumNet'),
    summaryMini:()=>$('summaryMini'), goalHint:()=>$('goalHint'),
    chips:()=>$('chips'), rangeCard:()=>$('rangeCard'), fromDate:()=>$('fromDate'), toDate:()=>$('toDate'), applyRange:()=>$('applyRange'),
    typeIncome:()=>$('typeIncome'), typeExpense:()=>$('typeExpense'), currencyPill:()=>$('currencyPill'),
    quickInput:()=>$('quickInput'), noteInput:()=>$('noteInput'), dateInput:()=>$('dateInput'), btnSave:()=>$('btnSave'), btnClear:()=>$('btnClear'),
    oneTap:()=>$('oneTap'),
    aiBox:()=>$('aiBox'), aiText:()=>$('aiText'), aiUse:()=>$('aiUse'), aiDismiss:()=>$('aiDismiss'),
    snack:()=>$('snack'), snackText:()=>$('snackText'), undoBtn:()=>$('undoBtn'),
    searchInput:()=>$('searchInput'), btnExport:()=>$('btnExport'), searchHint:()=>$('searchHint'),
    list:()=>$('list'), modalBackdrop:()=>$('modalBackdrop'),
    btnSettings:()=>$('btnSettings'), closeSettings:()=>$('closeSettings'), settingsSheet:()=>$('settingsSheet'),
    btnAssistant:()=>$('btnAssistant'), closeAssistant:()=>$('closeAssistant'), assistantSheet:()=>$('assistantSheet'),
    btnPrivacy:()=>$('btnPrivacy')
  };

  const LS_TX='sajil_tx_v3', LS_SET='sajil_set_v3';

  SAJiL.storage = {
    getTx(){ try{return JSON.parse(localStorage.getItem(LS_TX)||'[]');}catch(e){return [];} },
    setTx(v){ localStorage.setItem(LS_TX, JSON.stringify(v)); },
    getSettings(){
      const d={ enableUSD:true, guessType:true, privacy:false, autoTags:true, suggestCurrency:true, suggestReports:true, goalsOn:true, goalExpense:0, goalNet:0, lastCurrency:'₪', lastReportPrompt:'' };
      try{ return Object.assign(d, JSON.parse(localStorage.getItem(LS_SET)||'{}')||{}); }catch(e){ return d; }
    },
    setSettings(s){ localStorage.setItem(LS_SET, JSON.stringify(s)); }
  };

  SAJiL.util = {
    haptic(v=8){ try{ navigator.vibrate && navigator.vibrate(v);}catch(e){} },
    nowLocalISO(){ const d=new Date(Date.now()-new Date().getTimezoneOffset()*60000); return d.toISOString().slice(0,16); },
    id(){ return (crypto?.randomUUID?.() || (Date.now().toString(36)+Math.random().toString(36).slice(2))); },
    fmtMoney(a,c,priv){ const s=(Math.round((+a||0)*100)/100).toLocaleString('en-US',{maximumFractionDigits:2}); return (priv?'•••':s)+(c||'₪'); },
    fmtDate(iso){ const d=new Date(iso); return d.toLocaleDateString('en-GB')+' • '+d.toLocaleTimeString('en-GB',{hour:'2-digit',minute:'2-digit'}); },
    esc(s){ return String(s).replace(/[&<>"']/g,m=>({'&':'&amp;','<':'&lt;','>':'&gt;','"':'&quot;',"'":'&#039;'}[m])); }
  };

  SAJiL.periodLabel = (p)=>({today:'اليوم',yesterday:'أمس',before_yesterday:'قبل أمس',week:'أسبوع',month:'شهر',custom:'مخصص'})[p]||'اليوم';
  SAJiL.getRange = ()=>{
    const now=new Date(); const start=(d)=>new Date(d.getFullYear(),d.getMonth(),d.getDate(),0,0,0,0); const end=(d)=>new Date(d.getFullYear(),d.getMonth(),d.getDate(),23,59,59,999);
    const st=SAJiL.state;
    if(st.period==='today') return {from:start(now),to:end(now)};
    if(st.period==='yesterday'){const d=new Date(now);d.setDate(d.getDate()-1);return{from:start(d),to:end(d)};}
    if(st.period==='before_yesterday'){const d=new Date(now);d.setDate(d.getDate()-2);return{from:start(d),to:end(d)};}
    if(st.period==='week'){const d=new Date(now);d.setDate(d.getDate()-6);return{from:start(d),to:end(now)};}
    if(st.period==='month'){const d=new Date(now);d.setDate(d.getDate()-29);return{from:start(d),to:end(now)};}
    if(st.period==='custom') return {from:st.customFrom?start(st.customFrom):null,to:st.customTo?end(st.customTo):null};
    return {from:null,to:null};
  };

  SAJiL.filterTx = (all)=>{
    const r=SAJiL.getRange(); let items=all.filter(t=>{const ms=new Date(t.date).getTime(); if(r.from&&ms<r.from.getTime())return false; if(r.to&&ms>r.to.getTime())return false; return true;});
    if(SAJiL.features?.naturalSearch?.applyFilter) items=SAJiL.features.naturalSearch.applyFilter(items, SAJiL.state.search);
    else if(SAJiL.state.search){ const q=SAJiL.state.search.toLowerCase(); items=items.filter(t=>(t.note||'').toLowerCase().includes(q)); }
    items.sort((a,b)=>new Date(b.date)-new Date(a.date));
    return items;
  };

  SAJiL.summarizeByCurrency = (items)=>{
    const by={}; for(const t of items){ const c=t.currency||'₪'; by[c] ||= {income:0,expense:0,net:0}; if(t.type==='income') by[c].income += t.amount; else by[c].expense += t.amount; by[c].net = by[c].income - by[c].expense; } return by;
  };

  SAJiL.snack = (text)=>{ const ui=SAJiL.ui; ui.snackText().textContent=text; ui.snack().classList.remove('hidden'); clearTimeout(SAJiL.snack._t); SAJiL.snack._t=setTimeout(()=>ui.snack().classList.add('hidden'),5000); };

  SAJiL.commit = (tx)=>{
    const all=SAJiL.storage.getTx(); all.unshift(tx); SAJiL.storage.setTx(all);
    const s=SAJiL.state.settings; s.lastCurrency = tx.currency||'₪'; SAJiL.storage.setSettings(s);
    SAJiL.state.undo = tx;
    SAJiL.ui.quickInput().value=''; SAJiL.ui.noteInput().value=''; SAJiL.ui.dateInput().value=SAJiL.util.nowLocalISO();
    SAJiL.util.haptic(10); SAJiL.snack('تم الحفظ');
    if(SAJiL.features?.reports?.afterSave) SAJiL.features.reports.afterSave();
    SAJiL.render();
  };

  SAJiL.undo = ()=>{
    const last=SAJiL.state.undo; if(!last) return;
    SAJiL.storage.setTx(SAJiL.storage.getTx().filter(t=>t.id!==last.id));
    SAJiL.state.undo=null; SAJiL.util.haptic(10); SAJiL.snack('تم التراجع'); SAJiL.render();
  };

  SAJiL.render = ()=>{
    const ui=SAJiL.ui, st=SAJiL.state, s=st.settings;
    ui.periodLabel().textContent = SAJiL.periodLabel(st.period);
    const items = SAJiL.filterTx(SAJiL.storage.getTx());
    const by = SAJiL.summarizeByCurrency(items);
    const main = by['₪'] || {income:0,expense:0,net:0};
    ui.sumIncome().textContent = SAJiL.util.fmtMoney(main.income,'₪',s.privacy);
    ui.sumExpense().textContent = SAJiL.util.fmtMoney(main.expense,'₪',s.privacy);
    ui.sumNet().textContent = SAJiL.util.fmtMoney(main.net,'₪',s.privacy);
    const mini=[];
    if(by['$']){ const d=by['$']; mini.push(`بالدولار: ⬆︎ ${SAJiL.util.fmtMoney(d.income,'$',s.privacy)} • ⬇︎ ${SAJiL.util.fmtMoney(d.expense,'$',s.privacy)} • صافي ${SAJiL.util.fmtMoney(d.net,'$',s.privacy)}`); }
    mini.push(`عدد العمليات: ${items.length}`);
    ui.summaryMini().textContent = mini.join(' — ');
    ui.btnPrivacy().textContent = s.privacy ? '🙈' : '👁️';
    if(SAJiL.features?.goals?.renderHint) SAJiL.features.goals.renderHint(items);
    if(SAJiL.features?.oneTap?.render) SAJiL.features.oneTap.render();
    if(SAJiL.features?.swipeActions?.renderList) SAJiL.features.swipeActions.renderList(items);
    if(SAJiL.features?.naturalSearch?.renderHint) SAJiL.features.naturalSearch.renderHint(st.search);
  };

  function init(){
    SAJiL.state.settings = SAJiL.storage.getSettings();
    SAJiL.ui.dateInput().value = SAJiL.util.nowLocalISO();

    // chips
    SAJiL.ui.chips().addEventListener('click', (e)=>{
      const b=e.target.closest('.chip'); if(!b) return;
      SAJiL.ui.chips().querySelectorAll('.chip').forEach(x=>x.classList.remove('active'));
      b.classList.add('active');
      SAJiL.state.period=b.dataset.period;
      SAJiL.ui.rangeCard().classList.toggle('hidden', SAJiL.state.period!=='custom');
      SAJiL.render();
    });
    SAJiL.ui.applyRange().addEventListener('click', ()=>{
      SAJiL.state.customFrom = SAJiL.ui.fromDate().value ? new Date(SAJiL.ui.fromDate().value+'T00:00:00') : null;
      SAJiL.state.customTo = SAJiL.ui.toDate().value ? new Date(SAJiL.ui.toDate().value+'T23:59:59') : null;
      SAJiL.render();
    });

    // type
    const setType=(t)=>{ SAJiL.state.type=t; SAJiL.ui.typeIncome().classList.toggle('active',t==='income'); SAJiL.ui.typeExpense().classList.toggle('active',t==='expense'); SAJiL.util.haptic(5); };
    SAJiL.ui.typeIncome().addEventListener('click', ()=>setType('income'));
    SAJiL.ui.typeExpense().addEventListener('click', ()=>setType('expense'));

    SAJiL.ui.btnSave().addEventListener('click', ()=>SAJiL.features?.quickEntry?.saveFromUI && SAJiL.features.quickEntry.saveFromUI());
    SAJiL.ui.quickInput().addEventListener('keydown', (e)=>{ if(e.key==='Enter') SAJiL.features?.quickEntry?.saveFromUI && SAJiL.features.quickEntry.saveFromUI(); });
    SAJiL.ui.btnClear().addEventListener('click', ()=>{ SAJiL.ui.quickInput().value=''; SAJiL.ui.noteInput().value=''; SAJiL.ui.dateInput().value=SAJiL.util.nowLocalISO(); SAJiL.util.haptic(10); });

    SAJiL.ui.searchInput().addEventListener('input', ()=>{ SAJiL.state.search = SAJiL.ui.searchInput().value.trim(); SAJiL.render(); });

    SAJiL.ui.btnExport().addEventListener('click', ()=>{
      const items = SAJiL.filterTx(SAJiL.storage.getTx());
      const csv = SAJiL.features?.reports?.csvExport ? SAJiL.features.reports.csvExport(items) : '';
      const blob = new Blob([csv], {type:'text/csv;charset=utf-8'});
      const a=document.createElement('a'); a.href=URL.createObjectURL(blob);
      a.download=`SAJiL-export-${new Date().toISOString().slice(0,10)}.csv`; a.click();
      setTimeout(()=>URL.revokeObjectURL(a.href),2000);
    });

    SAJiL.ui.undoBtn().addEventListener('click', ()=>SAJiL.undo());

    // sheets
    const open=(sheet)=>{ SAJiL.ui.modalBackdrop().classList.remove('hidden'); sheet.classList.remove('hidden'); SAJiL.util.haptic(5); };
    const closeAll=()=>{ SAJiL.ui.modalBackdrop().classList.add('hidden'); SAJiL.ui.settingsSheet().classList.add('hidden'); SAJiL.ui.assistantSheet().classList.add('hidden'); };
    SAJiL.ui.modalBackdrop().addEventListener('click', closeAll);
    SAJiL.ui.btnSettings().addEventListener('click', ()=>open(SAJiL.ui.settingsSheet()));
    SAJiL.ui.closeSettings().addEventListener('click', closeAll);
    SAJiL.ui.btnAssistant().addEventListener('click', ()=>open(SAJiL.ui.assistantSheet()));
    SAJiL.ui.closeAssistant().addEventListener('click', closeAll);

    SAJiL.ui.btnPrivacy().addEventListener('click', ()=>{ const s=SAJiL.state.settings; s.privacy=!s.privacy; SAJiL.storage.setSettings(s); SAJiL.render(); });

    // AI
    SAJiL.ui.aiUse().addEventListener('click', ()=>SAJiL.features?.sideAI?.use && SAJiL.features.sideAI.use());
    SAJiL.ui.aiDismiss().addEventListener('click', ()=>SAJiL.features?.sideAI?.dismiss && SAJiL.features.sideAI.dismiss());

    // init features
    if(SAJiL.features) Object.values(SAJiL.features).forEach(f=>{ try{ f.init && f.init(); }catch(e){} });
    SAJiL.render();
  }

  document.addEventListener('DOMContentLoaded', init);
})();