(function(){
  const SAJiL = window.SAJIL = window.SAJIL || {};
  SAJiL.features = SAJiL.features || {};
  const F = SAJiL.features.billsDue = {};

  const $ = (id)=>document.getElementById(id);
  const BILLS_LS = 'sajil_bills_v1';

  function getBills(){ try{return JSON.parse(localStorage.getItem(BILLS_LS)||'[]');}catch{return [];} }
  function dayKey(d){ return (SAJiL.util?.dayKey ? SAJiL.util.dayKey(d) : d.toISOString().slice(0,10)); }

  function isDue(b, key){
    // dueDate stored as YYYY-MM-DD
    return b.enabled && b.dueDate === key;
  }

  function dueToday(){
    const key = dayKey(new Date());
    return getBills().filter(b=>b && isDue(b, key));
  }

  function dueThisWeek(){
    const now = new Date();
    const keys=[];
    for(let i=0;i<7;i++){
      const d=new Date(now); d.setDate(d.getDate()+i);
      keys.push(dayKey(d));
    }
    const bills = getBills().filter(b=>b && b.enabled);
    const due=[];
    bills.forEach(b=>{
      if(keys.includes(b.dueDate)) due.push(b);
    });
    return due;
  }

  function addBillAsTx(bill){
    const tx = {
      id: SAJiL.util.id(),
      type: 'expense',
      amount: +bill.amount || 0,
      currency: '₪',
      note: `[BILL-AUTO] ${bill.name} • ${bill.payLabel} • استحقاق ${bill.dueDate}`,
      date: new Date().toISOString(),
      tags: ['فاتورة'],
      createdAt: Date.now(),
      updatedAt: Date.now()
    };
    SAJiL.commit(tx);
    SAJiL.features?.history?.log && SAJiL.features.history.log('add', tx, {source:'bill-auto'});
  }

  function render(){
    const card = $('dueCard');
    const title = $('dueTitle');
    const text = $('dueText');
    const btn = $('dueAddAll');
    if(!card || !title || !text || !btn) return;

    const today = dueToday();
    const week = dueThisWeek();

    if(!today.length && !week.length){
      card.classList.add('hidden');
      return;
    }

    card.classList.remove('hidden');

    if(today.length){
      title.textContent = `🔔 فواتير مستحقة اليوم (${today.length})`;
      text.textContent = today.map(b=>`${b.name} • ${b.amount}₪`).join(' — ');
      btn.textContent = 'سجلهم اليوم';
      btn.onclick = ()=>{
        today.forEach(addBillAsTx);
        SAJiL.toast && SAJiL.toast('تم تسجيل فواتير اليوم ✅');
      };
    }else{
      title.textContent = `📅 فواتير هذا الأسبوع (${week.length})`;
      text.textContent = week.map(b=>`${b.dueDate}: ${b.name} • ${b.amount}₪`).join(' — ');
      btn.textContent = 'سجل أقربها';
      btn.onclick = ()=>{
        // سجل فواتير أول يوم قادم فيه فواتير
        const firstDate = week.map(b=>b.dueDate).sort()[0];
        week.filter(b=>b.dueDate===firstDate).forEach(addBillAsTx);
        SAJiL.toast && SAJiL.toast('تم تسجيل الفواتير الأقرب ✅');
      };
    }
  }

  F.render = render;
  F.init = function(){};
})();
